/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.bind;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.bind.RemoteSonarProject;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public class SearchEngineProvider
implements IContentProposalProvider {
    private final WizardPage parentPage;
    private final IServer server;
    private TextSearchIndex<RemoteModule> moduleIndex;

    public SearchEngineProvider(IServer server, WizardPage parentPage) {
        this.server = server;
        this.parentPage = parentPage;
    }

    public TextSearchIndex<RemoteModule> getModuleIndex() {
        if (this.moduleIndex == null && this.server.isUpdated()) {
            this.moduleIndex = this.server.getModuleIndex();
        }
        return this.moduleIndex;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (!this.server.isUpdated()) {
            this.parentPage.setMessage("Please update server first", 1);
            return new IContentProposal[0];
        }
        ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
        try {
            List modules = this.getModuleIndex().search(contents);
            for (RemoteModule m : modules) {
                RemoteSonarProject prj = new RemoteSonarProject(this.server.getId(), m.getKey(), m.getName());
                list.add(new ContentProposal(prj.asString(), m.getName(), prj.getDescription()));
            }
        }
        catch (Exception e) {
            SonarLintCorePlugin.getDefault().debug("Unable to search modules from server " + this.server.getName(), (Throwable)e);
        }
        if (!list.isEmpty()) {
            this.parentPage.setMessage("", 0);
            return list.toArray(new IContentProposal[list.size()]);
        }
        this.parentPage.setMessage("No results", 1);
        return new IContentProposal[0];
    }
}

